#include <bits/stdc++.h>

using namespace std;

const int mod = 1e9 + 7;

int add(int x, int y) { x += y; return x >= mod ? x - mod : x; }
int sub(int x, int y) { x -= y; return x < 0 ? x + mod : x; }
int mul(int x, int y) { return (x * 1LL * y) % mod; }

void sadd(int& x, int y) { x = add(x, y); }
void ssub(int& x, int y) { x = sub(x, y); }
void smul(int& x, int y) { x = mul(x, y); }

struct Fenwick {
    int n;
    vector<int> fw;
    Fenwick(int _n) {
        n = _n;
        fw.resize(n);
        for(int i = 0; i < n; i++) fw[i] = 0;
    }
    void update(int x, int val) { for(int i = x; i < n; i += (i & -i)) sadd(fw[i], val); }
    int get(int x) {
        int ans = 0;
        for(int i = x; i >= 1; i -= (i & -i)) sadd(ans, fw[i]);
        return ans;
    }
    int get(int l, int r) { return sub(get(r), get(l - 1)); }
    void clr() { for(int i = 0; i < n; i++) fw[i] = 0; }
};

const int N = 3e5 + 10;
int n, q;
int p[N], f[N];
int query[N];
int dp[N];

void Penjanje(int _n, int _q, int *_p, int *_f, int *_u, int *O) {
    n = _n;
    q = _q;
    for(int i = 1; i <= n; i++) {
        p[i] = _p[i];
        f[i] = _f[i];
    }
    for(int i = 1; i <= q; i++) query[i] = _u[i];
    Fenwick fw(n + 1);
    for(int rep = 1; rep <= q; rep++) {
        fw.clr();
        int x = query[rep];
        for(int i = x; i <= n; i++) {
            dp[i] = fw.get(max(f[i], x), i - 1);
            fw.update(i, add(mul(dp[i], p[i] - 1), p[i]));
        }
//        cout << rep << ": ";
//        for(int i = 1; i <= n; i++) cout << dp[i] << " ";
//        cout << "\n";
        int ans = 0;
        for(int i = x; i <= n; i++) sadd(ans, add(mul(dp[i], p[i] - 1), p[i]));
        O[rep] = ans;
    }
}
/*

6 2
4 2 1 2 1 4
1 2 1 3 2 5
1 4

*/